;[]------------------------------------------------------------------------[]
;| TOOLS - SOME REALLY NEAT STUFFS - HAVEN'T CLASSIFIED IT UNDER ANY        |
;| MANAGERS YET! :(                                                         |
;[]------------------------------------------------------------------------[]
DB 'TOOLS by Kenneth Foo aka TechnoMaestro/RDG. 1994.',01ah

;
;               REAL USEFUL HARDWARE/SOFTWARE IRQ STUFFS
;

;
;GetINT      - Get address pointed by interrupt
;
;INPUT: INTnumber
;OUTPUT:ES:BX=Address
;NOTE:  *Interrupt flag not cleared!*
GetINT  PROC    USES AX DS,IntNum:WORD
	XOR     AX,AX
	MOV     DS,AX
	MOV     BX,IntNum
	SHL     BX,2
	MOV     AX,WORD PTR HandlerAddress[2]
	MOV     ES,[BX+2]
	MOV     AX,WORD PTR HandlerAddress[0]
	MOV     BX,[BX]
	RET
	GetINT  ENDP
;
;SetINT      - Set address pointed by interrupt
;
;INPUT: INTnumber, Address(DD)
;OUTPUT:-
;NOTE:  *Interrupt flag not cleared!*
SetINT  PROC    USES AX BX DS,IntNum:WORD,HandlerAddress:DWORD
	XOR     AX,AX
	MOV     DS,AX
	MOV     BX,IntNum
	SHL     BX,2
	MOV     AX,WORD PTR HandlerAddress[0]
	MOV     [BX],AX
	MOV     AX,WORD PTR HandlerAddress[2]
	MOV     [BX+2],AX
	RET
	SetINT  ENDP
;
;GetIRQ      - Get address pointed by IRQ (hardware interrupt)
;
;INPUT: IRQnumber
;OUTPUT:ES:BX=Address
;NOTE:  *Interrupt flag not cleared!*
GetIRQ  PROC    USES AX DS,IrqNum:WORD
	cmp     IrqNum,7
	ja      short @@HighIRQ
	add     IrqNum,008h     ;Starts from software Int 8
	jmp     short @@Done
	@@HighIRQ:
	add     IrqNum,070h     ;Starts from software Int 70h
	@@Done:
	push    IrqNum
	call    GetINT          ;-)
	ret
	GetIRQ  ENDP
;
;SetIRQ      - Set address pointed by IRQ (hardware interrupt)
;
;INPUT: IRQnumber, Address(DD)
;OUTPUT:-
;NOTE:  *Interrupt flag not cleared!*
SetIRQ  PROC    USES AX BX DS,IrqNum:WORD,HandlerAddress:DWORD
	cmp     IrqNum,7
	ja      short @@HighIRQ
	add     IrqNum,008h     ;Starts from software Int 8
	jmp     short @@Done
	@@HighIRQ:
	add     IrqNum,070h     ;Starts from software Int 70h
	@@Done:
	push    IrqNum
	push    HandlerAddress
	call    SetINT          ;-)
	ret
	SetIRQ  ENDP
;
;EnableIRQ - Enable IRQ 
;
;INPUT: IRQnumber
;OUTPUT:-
;NOTE:  *Interrupt flag not cleared!*
EnableIRQ PROC    USES AX CX,IrqNum:WORD
	mov     cx,IrqNum
	mov     ah,11111110b
	rol     ah,cl
	cmp     cl,7
	ja      short @@HighIRQ
	in      al,021h
	and     al,ah
	out     021h,al
	jmp     short @@Done
	@@HighIRQ:
	in      al,0a1h
	and     al,ah
	out     0a1h,al
	@@Done:
	ret
	EnableIRQ ENDP
;
;DisableIRQ - Disable IRQ 
;
;INPUT: IRQnumber
;OUTPUT:-
;NOTE:  *Interrupt flag not cleared!*
DisableIRQ PROC    USES AX CX,IrqNum:WORD
	mov     cx,IrqNum
	mov     ah,00000001b
	rol     ah,cl           ;Even if CL > 7, 8=0 ! (No change! :)
	cmp     cl,7
	ja      short @@HighIRQ
	in      al,021h
	or      al,ah
	out     021h,al
	jmp     short @@Done
	@@HighIRQ:
	in      al,0a1h
	or      al,ah
	out     0a1h,al
	@@Done:
	ret
	DisableIRQ ENDP
;
;SendEOI - Send EOI flag to interrupt controller 
;
;INPUT: -
;OUTPUT:-
;NOTE:  -
SendEOI PROC    USES AX
	mov     al,020h
	out     020h,al
	out     0a0h,al
	ret
	SendEOI ENDP



;
;                      REAL USEFUL DMA STUFFS
;
	;DMA port addresses     PAGE
	;                        |  BASE ADDRESS
	;                        |    |
	;                        |    |
	;                        |    |
	DMAports        dw      087h,000h       ;DMA 0-3
			dw      083h,002h
			dw      081h,004h
			dw      082h,006h
			dw      08Fh,0C0h       ;DMA 4-7
			dw      08Bh,0C4h
			dw      089h,0C8h
			dw      08Ah,0CCh
;
;SetDMA - Programs the DMA controller (0-7).
;
;!!!!!!!! Must make it correctly!
;I:     Channel, Mode, Address(Offset), Page, Length (number elements)
;O:     -
;N:     Original code written by Draeden of VLA. Thanx! :)
;       For DMA 0-3 which is 8-bit, each elements are in bytes.
;IGNORE THIS STATEMENT     * For DMA 4-7 which is 8-bit, each elements are in WORDS.
SetDMA  PROC USES AX BX CX DX,\
			DMAchannel:byte,\
			DMAmode:byte,\
			DMAaddress:word,\
			DMApage:byte,\
			DMAlength:word
	cmp     DMAchannel,4
	jae     @@DoDMA47
	;DMA 0-3
	mov     al,DMAchannel   ;Mask reg bit
	or      al,4
	out     0Ah,al
	xor     al,al           ;Clr byte ptr
	out     0Ch,al
	mov     al,DMAchannel   ;Set mode reg
	add     al,DMAmode
	out     0Bh,al

	mov     bl,DMAchannel   ;Set base address low
	xor     bh,bh
	shl     bx,2
	push    DMAports[bx+0]

	mov     dx,DMAports[bx+2]
	mov     bx,DMAaddress
	mov     al,bl
	out     dx,al
	mov     al,bh           ;Set base address high
	out     dx,al
	inc     dx              ;Point to length port
	mov     cx,DMAlength
	dec     cx              ;count -1
	mov     al,cl           ;Set length low
	out     dx,al
	mov     al,ch           ;Set length high
	out     dx,al

	pop     dx
	mov     al,DMApage      ;Set DMA page reg
	out     dx,al

	mov     al,DMAchannel   ;Unmask (activate) dma channel
	out     0Ah,al
	ret

	;DMA 4-7
	@@DoDMA47:
	mov     al,DMAchannel   ;Mask reg bit
	or      al,4
	out     0D4h,al
	xor     al,al           ;Clr byte ptr
	out     0D8h,al
	mov     al,DMAchannel   ;Set mode reg
	and     al,11b          ;= sub     al,4
	add     al,DMAmode
	out     0D6h,al

	mov     bl,DMAchannel   ;Set base address low
	xor     bh,bh
	shl     bx,2
	push    DMAports[bx+0]

	mov     dx,DMAports[bx+2]
	mov     bx,DMAaddress
	shr     bx,1            ;16-BIT == OFFSET IN WORDS!
	mov     al,bl
	out     dx,al
	mov     al,bh           ;Set base address high
	out     dx,al
	add     dl,2            ;Point to length port
	mov     cx,DMAlength
	shr     cx,1            ;16-BIT == COUNT IN WORDS!
	dec     cx              ;count -1
	mov     al,cl           ;Set length low
	out     dx,al
	mov     al,ch           ;Set length high
	out     dx,al

	pop     dx
	mov     al,DMApage      ;Set DMA page reg
	out     dx,al

	mov     al,DMAchannel   ;Unmask (activate) dma channel
	and     al,11b          ;= sub     al,4
	out     0D4h,al
	ret
	SetDMA  ENDP

;
;StopDMA - Stop DMA in progress
;
;I:     Channel:B
StopDMA PROC USES AX, DMAchannel:byte
	mov     al,DMAchannel   ;Mask reg bit
	and     al,11b          ;Mask out (disable) DMA channel
	or      al,4            ;And clear byte pointer flip-flop.
	cmp     DMAchannel,4
	jb      @@DoDMA03
	out     0D4h,al
	xor     al,al
	out     0D8h,al
	ret
	@@DoDMA03:
	out     00Ah,al
	xor     al,al
	out     00Ch,al
	ret
	ENDP

;
;GetDMApos - Get DMA position
;
;I:     Channel, BufferSizeInByte:W
;O:     AX=Position in DMA buffer
;N:     Original code from MIDAS sound system.
;       For DMA 0-3 which is 8-bit, each elements are in bytes.
;IGNORE THIS STATEMENT          * For DMA 4-7 which is 8-bit, each elements are in WORDS.
CODE_ALIGN
GetDMApos PROC USES BX CX DX, DMAchannel:WORD, BufSize:WORD
	;SETUP CHANNELS
	mov     bx,DMAchannel
	shl     bx,2
	mov     cx,DMAports[bx+2]
	inc     cx
	mov     dx,0ch
	cmp     bx,4*4
	jb      short @@LowDMA
	mov     dx,0d8h
	inc     cx
	@@LowDMA:
	xor     al,al                   ;OTTO CHRONS USED 0FFh!
	out     dx,al                   ;Clear flip-flop (byte ptr)
	mov     dx,cx
	mov     cx,BufSize
	;READ VALUE OF CHANNELS
	pushf
	cli
	ALIGN 2
	@@ReadDMA:
	in      al,dx                   ;Read first word count
	mov     ah,al
	in      al,dx
	xchg    al,ah
	mov     bx,ax
;jmp     $+2     ;shitty...
	in      al,dx                   ;Read second word count
	mov     ah,al
	in      al,dx
	xchg    al,ah
	sub     bx,ax                   ;If difference > 4, EMM is playing
  cmp     bx,32*2                 ;tricks! So, must reread!
	jg      short @@ReadDMA         ;OTTO CHRONS USED > 64!
  cmp     bx,-32*2
	jl      short @@ReadDMA
	;cmp     bx,0
	;jge     short @@PosLen
	;neg     bx
	;@@PosLen:
	cmp     bx,cx                   ;Or if position > Buffer size
	jae     short @@ReadDMA         ;it's a bad value! Reread!
	popf                            ;OTTO CHRONS DIDN'T USE THIS.
	;READ VALUE OF CHANNELS
	cmp     DMAchannel,4            ;If channel 16-bit, convert pos to
	jb      short @@Not16Bit        ;bytes!
	shl     ax,1
	@@Not16Bit:
	neg     ax                      ;pos=bufsize-ByteCount
	add     ax,cx
	ret
	GetDMApos ENDP

