// -*-c++-*- 
#ifndef _SAMPLE_H_
#define _SAMPLE_H_
#include "types.h"
#include "formats.h" // for the stucts for reading & writing formats

// All loaders and savers return 0 on error and set 
// error_message appropriately. A 1 is returned on success.

class Sample
{
public:
  Sample(void);
  ~Sample(void);

  // generic 
  int load(const char *filename);
  int save(const char *filename);
  
  bool is_sample(const char *filename);
  int dump(void);

  // specific
  int loadIFF (const char *filename);
  int loadRAW (const char *filename);
  int loadVOC (const char *filename);  
  int loadWAV (const char *filename);
  int loadAU  (const char *filename);

  int saveIFF (const char *filename);
  int saveRAW (const char *filename);
  int saveVOC (const char *filename);  
  int saveWAV (const char *filename);
  int saveAU  (const char *filename);

  char *error_message;

  //private:
  char   *name;
  ubyte  *data;

  udword length; // length of data in bytes
  udword loop_start;
  udword loop_end;
  uword  frequency;
  ubyte  finetune;
  sbyte  relative_note;
  ubyte  flags;
  ubyte  volume;
  ubyte  panning;

  // constants for flags
  static const ubyte SMP_16BIT  = 0x01;
  static const ubyte SMP_LOOP   = 0x02;
  static const ubyte SMP_BIDI   = 0x04;
  static const ubyte SMP_STEREO = 0x08;
  static const ubyte SMP_SIGNED = 0x10;
};

#endif
