/* 
 * Standard includes
 */
#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <getopt.h>
#include "module.h"
#include "dsp.h"

long int pat = 0;
long int ch = 0;

void getoptions(int count, char **argument);
char *note_to_string(byte note);
void usage(char *filename);

int main(int argc, char **argv)
{
  Module *mod = 0;
  
  if (argc <= 1) 
    {
      usage(argv[0]);
    }
  
  getoptions(argc,argv);
  for (int j = optind; j < argc; j++) 
    {
      mod = new Module;
      if (!Module::is_module(argv[j]))
	continue;
      printf("\n==== File : [%s] ====\n", argv[j]);
      if (!mod->load(argv[j]))
	{
	  printf("%s\n", mod->error_message);
	  continue;
	}
      //#ifdef DEBUG
      // display some pattern data
      if (!pat)
	pat = mod->order[0];
      for (int i = 0; i < mod->rows[pat]; i++)
	{
	  printf("%.2x ", i);
	  for (int k = ch; (k < ch+4) && (k < mod->channels); k++)
	    {
	      Note n = mod->PatternData[pat][k][i];
	      printf("| %s ", note_to_string(n.NoteNum));
	      if (n.number)
		printf("%2X ",n.number);
	      else
		printf("-- ");
	      if (n.volume)
		{
		  if (n.volume < 0x51)
		    printf("%2X ", n.volume-1);
		  else
		    printf("%2X ", n.volume);		    
		}
	      else
		printf("-- ");
	      if (n.effect || n.effParam)
		printf("%2X%.2X ",n.effect,n.effParam);
	      else
		printf("---- ");	      
	    }
	  printf("|\n");
	}
      //#endif
      // play each sample at 44100 hz
      DSP d(44100);
      if (d.error)
	{
	  printf("error creating DSP!\n");
	  exit(1);
	}
      printf("NumSamples %d\n", mod->NumSamples);
      for (int i = 0; i < mod->NumSamples; i++) 
	{	  
	  if (mod->samples[i])
	    {
	      if (mod->samples[i]->length > 1) 
		{
		  printf("playing sample %d\n", i);
		  d.play(mod->samples[i]->data,mod->samples[i]->length);
		  d.sync();
		  usleep(500);
		}
	    }
	}
      mod->dump();
      // free old mod data ?
    }

  printf("\n");
  exit(0);
}

void getoptions(int count, char **argument)
{
  /* get the options */
  while (1) 
    {
      int option_index = 0;
      int c;
      static struct option long_options[] =
      {
	{"help"  ,  0, 0, 'h'},
	{"pattern", 1, 0, 'p'},
	{"channel", 1, 0, 'c'},
	{0, 0, 0, 0}
      };
      
      c = getopt_long (count, argument, "hc:p:", long_options, &option_index);
      if (c == -1)
	break;
    
      switch (c)
	{
	case 'c':
	  ch = strtol(optarg,0,10);
	  break;
	case 'h' :
	  usage(argument[0]);
	  break;
	case 'p' : 
	  printf("Pattern : %s\n", optarg);
	  /* convert the string to a long integer */
	  pat = strtol(optarg,0,10);
	  break;
	default:
	  printf ("?? getopt returned character code 0%o ??\n", c);
	}
    }
}

void usage(char *filename)
{
  printf("usage : %s [ -p pattern ][ -c channel ] sample_file\n", filename);
  exit(-1);
}

char *note_to_string(byte note)
{
  char *str = (char *)malloc(4);
  if (!note)
    return "---";
  if (note == 254)
    return "^^^";
  switch ((note-1) % 12)
    {
    case 0: 
      str[0] = 'C'; str[1] = '-';
      break;
    case 1:
      str[0] = 'C'; str[1] = '#';
      break;
    case 2:
      str[0] = 'D'; str[1] = '-';
      break;
    case 3:
      str[0] = 'D'; str[1] = '#';
      break;
    case 4:
      str[0] = 'E'; str[1] = '-';
      break;
    case 5:
      str[0] = 'F'; str[1] = '-';
      break;
    case 6:
      str[0] = 'F'; str[1] = '#';
      break;
    case 7:
      str[0] = 'G'; str[1] = '-';
      break;
    case 8:
      str[0] = 'G'; str[1] = '#';
      break;
    case 9:
      str[0] = 'A'; str[1] = '-';
      break;
    case 10:
      str[0] = 'A'; str[1] = '#';
      break;
    case 11:
      str[0] = 'B'; str[1] = '-';
      break;
    default:      
      return "---";
    }   
  str[2] = (char)((note / 12) + '0');
  str[3] = 0;
  return str;
}

