	DOSSEG
	.286
	.MODEL SMALL
	.STACK  200h
	.CODE
	ASSUME  cs:@code, ds:@code, es:@code

;=======- DMA GLOBALS

	GLOBAL  Status:WORD
	GLOBAL  IntNumber:BYTE, BaseAddress:WORD

;=======-   MOD SUB GLOBALS

	GLOBAL  StartPlaying:NEAR, StopPlaying:NEAR
	GLOBAL  Mute:NEAR, UnMute:NEAR
	GLOBAL  UpDate:NEAR

	GLOBAL  ModSeg:WORD, ComputerSpeed:BYTE ;range 1-6?
	GLOBAL  ModName:BYTE, MasterVolume:byte

;=====- Command line capture
;FILE: MCLSUB.ASM
;upon entry: 
;
;*      ES= PSP SEG 
;*      DS:DX = pointer to filename area
;*      DS:BX = pointer to 5 byte 0 terminating Extension to add
;
;RETURN:    AX= length of command line

GLOBAL  GetCommandLine:NEAR

;=======- Necessary DATA

	ModName     db  0,130 dup (0)   ;filename goes here
	Extension   db  ".MOD",0,"$"
	ModSeg      dw  0
	DspSeg      dw  0

	Credits db  10
			db  "                       AI MOD player by Draeden of VLA! ",13,10
			db  "                      ",13,10
			db  "                        Gauranteed to play your MOD in  ",13,10
			db  "                        a way that was never intended!  ",13,10,10
			db  "                          -=Press any key to exit!=-    ",13,10
			db  "$"

	ErrorMsg  db "Error loading file.$"

;=======- START MAIN

Start:
	mov     ax,es
	mov     cs:[DspSeg],ax
	mov     ax,cs
	mov     ds,ax
	mov     bx,ss
	add     bx,20h
	mov     [ModSeg],bx      ;MUST be last one - stacks on top of it
	mov     [ComputerSpeed],6   ;range 0-6
	mov     [IntNumber],7       ; the IRQ number
	mov     [BaseAddress],220h  ;base I/O address- DMA channel is ONE
	mov     [MasterVolume],255  ;max volume

	mov     dx,offset ModName
	mov     bx,offset Extension
	call    GetCommandLine
	
	or      ax,ax
	je      ExitError

	mov     ax,0003h    ;reset 80x25x16 (clear screen)
	int     10h

	mov     ax,cs
	mov     ds,ax
	mov     dx,offset Credits
	mov     ah,9
	int     21h

	mov     ah,2
	mov     dx,2000h
	mov     bx,0
	int     10h         ;move cursor off screen

	call    StartPlaying    ;this loads and begins playing the MOD
	cmp     ax,-1           ;returns ax=-1 if something went wrong
	je      ExitError
MainLoop:
	call    Update          ;must be called- updates the mixed data

	mov     ah,1            ;check for keypress
	int     16h
	jz      MainLoop

	mov     ah,0            ;get keypress
	int     16h

ExitAllDone:
	call    StopPlaying     ;turns off speaker, resets all interrupts changed
	
	mov     ah,2
	mov     dx,1000h
	mov     bx,0
	int     10h         ;move cursor back on screen

ByeBye:
	mov     ax,4c00h
	int     21h

ExitError:
	push    cs
	pop     ds
	mov     ah,9
	mov     dx,offset ErrorMsg
	int     21h
	jmp     ByeBye

END Start



