Unit GOLDPLAY;

INTERFACE
Procedure AskInit;
Procedure Initialize;
Procedure LoadModule(Mfile:String);
Procedure StartPlaying;
Procedure StopPlaying;
Procedure DeAlloc;
Procedure SetSys(SDEV,TSPEED,SBDMA,SBIRQ,SBPORT:WORD);
Procedure LoadOVL(FNamn:String);
Procedure RemoveOVL;
Procedure MasterVolume(MastVol:Word);
Function  BopBar(BarNo:Word):Word;

Var Error:Word;

IMPLEMENTATION

Var F:File;
    PlayPoint:Pointer;
    PlaySeg:Word;
    PlaySize:Word;

    SAskInit     :Procedure;
    SInitialize  :Procedure;
    SLoadModule  :Procedure;
    SStartPlaying:Procedure;
    SStopPlaying :Procedure;
    SDeAlloc     :Procedure;
    SDPoint	 :Pointer;

    Temp:Word;
    ModNamn:String;

Var SSDev,STSpeed,SSBDMA,SSBIRQ,SSBPort:Word;

Const PlayerLoaded:Boolean=False;

Procedure ASKINIT;
Begin;
If PlayerLoaded then SASKINIT;
End;

Procedure Initialize;
Begin;
If PlayerLoaded then SINITIALIZE;
End;

Procedure LoadModule(MFile:String);
Begin;
Error:=0;
If PlayerLoaded then
Begin;
ModNamn:=MFile+#0;

Asm;
Mov Dx,Offset [ModNamn+1]
Call SLoadModule
Jnc @NoError
Mov Error,Ax
@NoError:
End;
End;
End;

Procedure StartPlaying;
Begin;

If (PlayerLoaded) and (Error=0) then SStartPlaying;
End;

Procedure StopPlaying;
Begin;
If (PlayerLoaded) and (Error=0) then SStopPlaying;
End;

Procedure DeAlloc;
Begin;
If (PlayerLoaded) and (Error=0) then SDeAlloc;
End;

Procedure LoadOVL(FNamn:String);
Begin;
If PlayerLoaded=True then exit;
GetMem(PlayPoint,40000);
Asm
Mov  Ax,Word Ptr PlayPoint+2
Mov  PlaySeg,Ax
End;
Assign(F,FNamn);
Reset(F,1);
{$I-}
BlockRead(F,Temp,2);
Asm;
Mov Ax,Temp
Mov Word Ptr sAskInit,Ax
Mov Ax,PlaySeg
Mov Word Ptr sAskInit+2,Ax
End;
BlockRead(F,Temp,2);
Asm;
Mov Ax,Temp
Mov Word Ptr SInitialize,Ax
Mov Ax,PlaySeg
Mov Word Ptr SInitialize+2,Ax
End;
BlockRead(F,Temp,2);
Asm;
Mov Ax,Temp
Mov Word Ptr SLoadModule,Ax
Mov Ax,PlaySeg
Mov Word Ptr SLoadModule+2,Ax
End;
BlockRead(F,Temp,2);
Asm;
Mov Ax,Temp
Mov Word Ptr SStartplaying,Ax
Mov Ax,PlaySeg
Mov Word Ptr SStartplaying+2,Ax
End;
BlockRead(F,Temp,2);
Asm;
Mov Ax,Temp
Mov Word Ptr SStopPlaying,Ax
Mov Ax,PlaySeg
Mov Word Ptr SStopPlaying+2,Ax
End;
BlockRead(F,Temp,2);
Asm;
Mov Ax,Temp
Mov Word Ptr SDeAlloc,Ax
Mov Ax,PlaySeg
Mov Word Ptr SDeAlloc+2,Ax
End;
BlockRead(F,Temp,2);
Asm;
Mov Ax,Temp
Mov Word Ptr SDPoint,Ax
Mov Ax,PlaySeg
Mov Word Ptr SDPoint+2,Ax
End;
BlockRead(F,PlayPoint^,40000,PlaySize);
Asm;
Push Es
Mov  Es,PlaySeg
Mov  Cx,PlaySize
Shr  Cx,1
Mov  Bx,0

@UnCode:
Mov  Ax,Es:[Bx]
Ror  Ax,7
Xor  Ax,Cx
Xor  Ax,0B32Ah
Mov  Es:[Bx],Ax
Add  Bx,2
Loop @UnCode
Pop  Es
End;


{$I+}
Close(F);
PlayerLoaded:=True;
End;

Procedure RemoveOvl;
Begin;
FreeMem(PlayPoint,40000);
PlayerLoaded:=False;
End;

Procedure MasterVolume(MastVol:Word);
Begin;
If PlayerLoaded=False then Exit;
temp:=MastVol;
Asm;
Push Es
Mov  Bx,word ptr [SDPoint]
Mov  Es,word ptr [SDPoint+2]
Mov  Ax,Temp
Mov  Es:[Bx+10],Ax
Pop Es
End;
End;

Function BopBar(BarNo:Word):Word;
Begin;
If PlayerLoaded=False then Exit;
If (BarNo=0) or (Barno>4) then begin;BopBar:=0;Exit;End;
temp:=BarNo;
Asm;
Push Es
Mov  Bx,word ptr [SDPoint]
Mov  Es,word ptr [SDPoint+2]
Mov  Ax,Temp
Shl  Ax,1
Add  Bx,Ax
Mov  Ax,Es:[Bx+10]
Mov  Temp,Ax
Pop Es
End;
BopBar:=Temp;
End;

Procedure SetSys(SDEV,TSPEED,SBDMA,SBIRQ,SBPORT:WORD);
Begin;
If PlayerLoaded=False then Exit;
SSDEV:=SDEV; STSPEED:=TSPEED; SSBDMA:=SBDMA; SSBIRQ:=SBIRQ; SSBPORT:=SBPORT;
Asm;
Push Es
Mov  Bx,word ptr [SDPoint]
Mov  Es,word ptr [SDPoint+2]
Mov  Ax,SSDev
Mov  word ptr Es:[BX],Ax
Mov  Ax,StSpeed
Mov  word ptr Es:[BX+2],Ax
Mov  Ax,SSBDMA
Mov  word ptr Es:[BX+4],Ax
Mov  Ax,SSBIRQ
Mov  word ptr Es:[BX+6],Ax
Mov  Ax,SSBPORT
Mov  word ptr Es:[BX+8],Ax
Pop  Es
End;
End;

End.