//***************************************************************************
//
// this file is (c) '94-'96 Niklas Beisert
//
// this file is part of the cubic player development kit.
// you may only use/modify/spread this file under the terms stated
// in the cubic player development kit accompanying documentation.
//
//***************************************************************************

class binfile;
struct moduleinfostruct;
struct cpifaceplayerstruct
{
  int (*OpenFile)(const char *path, moduleinfostruct &info, binfile *f);
  void (*CloseFile)();
};

extern unsigned short plNLChan;
extern unsigned short plNPChan;
extern unsigned char plSelCh;
extern unsigned char plChanChanged;
extern char plPause;
extern char plMuteCh[];
extern char plPanType;
extern int (*plProcessKey)(unsigned short key);
extern void (*plDrawGStrings)(short (*plTitleBuf)[132]);
extern void (*plGetRealMasterVolume)(int &l, int &r);
extern void (*plGetMasterSample)(short *, int len, int rate, int mode);
extern int (*plIsEnd)();
extern void (*plIdle)();
extern void (*plSetMute)(int i, int m);
extern int (*plGetLChanSample)(int ch, short *, int len, int rate);
extern int (*plGetPChanSample)(int ch, short *, int len, int rate);

struct cpimoderegstruct
{
  char handle[9];
  void (*SetMode)();
  void (*Draw)();
  int (*IProcessKey)(unsigned short);
  int (*AProcessKey)(unsigned short);
  int (*Event)(int ev);
/*
  int (*Open)();
  void (*Close)();
  int (*Init)();
  void (*Done)();
  int (*InitAll)();
  void (*DoneAll)();
*/
  cpimoderegstruct *next;
  cpimoderegstruct *nextdef;
};

struct cpitextmoderegstruct;

struct cpitextmodequerystruct
{
  unsigned char top;
  unsigned char xmode;
  unsigned char killprio;
  unsigned char viewprio;
  unsigned char size;
  int hgtmin;
  int hgtmax;
  cpitextmoderegstruct *owner;
};

struct cpitextmoderegstruct
{
  char handle[9];
  int (*GetWin)(cpitextmodequerystruct &q);
  void (*SetWin)(int xmin, int xwid, int ymin, int ywid);
  void (*Draw)(int focus);
  int (*IProcessKey)(unsigned short);
  int (*AProcessKey)(unsigned short);
  int (*Event)(int ev);
/*
  int (*GetFocus)();
  void (*LoseFocus)();
  int (*Open)();
  void (*Close)();
  int (*Init)();
  void (*Done)();
  int (*InitAll)();
  void (*DoneAll)();
  void (*SetMode)();
*/
  int active;
  cpitextmoderegstruct *nextact;
  cpitextmoderegstruct *next;
  cpitextmoderegstruct *nextdef;
};

enum
{
  cpievOpen, cpievClose, cpievInit, cpievDone, cpievInitAll, cpievDoneAll,
  cpievGetFocus, cpievLoseFocus, cpievSetMode,
};

void cpiDrawGStrings();
void cpiSetGraphMode(int big);
void cpiSetTextMode(int size);
void plReadCubicPic();
void cpiResetScreen();
void cpiRegisterMode(cpimoderegstruct *m);
void cpiSetMode(const char *hand);
void cpiGetMode(char *hand);
void cpiTextRegisterMode(cpitextmoderegstruct *mode);
void cpiTextSetMode(const char *name);
void cpiTextRecalc();

void plUseMessage(char **);

struct insdisplaystruct
{
  int n40,n52,n80;
  char *title80;
  char *title132;
  void (*Mark)();
  void (*Clear)();
  void (*Display)(short *buf, int len, int n, int mode);
  void (*Done)();
};

void plUseInstruments(insdisplaystruct &x);

void plUseChannels(void (*Display)(short *buf, int len, int i));
extern int plTrackActive;

struct notedotsdata
{
  unsigned char chan;
  unsigned short note;
  unsigned short voll,volr;
  unsigned char col;
};

void plUseDots(int (*get)(notedotsdata *, int));
