uses modunit,dos,crt;
const
hex_tbl : array[0..15] of char = ('0','1','2','3','4','5','6','7',
                                  '8','9','A','B','C','D','E','F');

function findgus : word;
{Returns Base address and sets GUS IRQ if ULTRASND environment found}
var
n,c,i : word;
s : string;
begin
  s := getenv('ultrasnd');
  if s = '' then begin
    findgus := 0;
    exit;
  end;
  val(copy(s,1,3),n,c);
  if c <> 0 then begin
    findgus := 0;
    exit;
  end;
  case n of
    210 : i := $210;
    220 : i := $220;
    230 : i := $230;
    240 : i := $240;
    250 : i := $250;
    260 : i := $260;
    270 : i := $270;
    else begin
      findgus := 0;
      exit;
    end;
  end;
  for n := 1 to 3 do delete(s,1,pos(',',s));
  if gus_irq = 0 then begin
    val(copy(s,1,pos(',',s)-1),gus_irq,c); {Set IRQ}
    if c <> 0 then gus_irq := 0;
  end;
  findgus := i;
end;

begin
  if paramcount < 1 then halt(1);

  gus_base := findgus;  {Look for ULTRASND environment. Set base port & IRQ}
  gusfind;  {This HARDWARE DETECTS your GUS. It DOES NOT look for ULTRASND
             environment. You MUST call this even if you set base address
             directly!}
  gusreset; {Reset GUS}
  writeln('GUS found at ',gus_base,' IRQ ',gus_irq,
          ' with ',gusfindmem,' bytes of memory');

  {gus_irq := 0}  {If you want to use system timer}
  {gus_irq := 11} {If you want to use GUS's irq (11 in this case)}
  init_mod;  {Initialises mod routines and sets up interrupt}

  load_mod(paramstr(1));  {Loads mod/s3m}
  if mod_error <> 0 then begin
    writeln('Load error!');
    halt(1);
  end;
  start_playing;  {Starts playing}

  writeln('Playing ',paramstr(1));
  repeat
    write(#13,'POS:',cur_ptn:2,' ROW:',cur_row:2);
  until keypressed;
  readkey;
  writeln;

  stop_playing; {Stops playing}
  free_mod;     {Frees memory taken by mod}
  done_mod;     {Restores interrupt and deinit's GUS. You MUST call this at
                 the end of your program!}
end.

